(load "mscv.scm")

;;; basic tests
(eval-prog '10)
(eval (parse 'x) (new-env (list 'x) (list 15)))
(eval (parse '(+ 1 x)) (new-env (list 'x) (list 15)))
(eval-prog '(fun (x y) (+ x y)))
(eval (parse '(let ((y 10)) (+ y x))) (new-env (list 'x) (list 15)))
(eval-prog '(let ((f (fun (x y) (+ x y))))
          (f 3 4)))

;; side effects
(eval (parse '(let ((y 10)) 
                (+ y x)
                (set! x 2)
                (+ y x))) (new-env (list 'x) (list 15)))

(eval-prog '(let ((v 0))
                (let ((f (fun (y) (set! y 5))))
                  (f v)
                  v)))

(printf "--------\n")
(eval-prog '(let ((ctx 1))
                (let ((x (make-cv (fun () ctx) 10)))
                  (set! ctx 2)
                  (set! x 3)
                  (printf "x is ~s\n" x)
                  (set! ctx 1)
                  (printf "x is ~s\n" x)
                  (set! x 5)
                  (printf "x is ~s\n" x)
                  (set! ctx 2)
                  (printf "x is ~s\n" x)
                  )))

(printf "--------\n")
(eval-prog '(let ((ctx 1) (ctx2 'a))
                (let ((x 2))
                  (set! x (make-cv (fun () ctx) x))
                  (let ((y (make-cv (fun () ctx2) 0)))
                    (set! x 3)               ;;; 1a
                    (set! y x)
                    (printf "x is ~s\n" x)
                    (printf "y is ~s\n\n" y)
                    (set! ctx2 'b)          ;;; 1b
                    (printf "x is ~s\n" x)
                    (printf "y is ~s\n\n" y)                    
                    (set! ctx 2)          ;;; 2b
                    (printf "x is ~s\n" x)
                    (printf "y is ~s\n\n" y)
                    (set! ctx2 'a)          ;;; 2a
                    (printf "x is ~s\n" x)
                    (printf "y is ~s\n\n" y)
                  ))))

(printf "----interaction with function application----\n")
(eval-prog '(let ((ctx 1))
                (let ((printit (fun (arg)
                                    (set! ctx 1)
                                    (printf "arg is ~s\n" arg)))) 
                  (let ((x (make-cv (fun () ctx) 10)))
                    (set! ctx 2)
                    (set! x 5)
                    (printit x)))))

(printf "----interaction with function application/let----\n")
(eval-prog '(let ((ctx 1))
                (let ((x (make-cv (fun () ctx) 10)))
                  (set! ctx 2)
                  (set! x 5)
                  (let ((y x))
                    (set! ctx 1)
                    (printf "y is ~s\n" y)
                    (cv-trace y)))))

(printf "----call-by-value semantics for contextual values too----\n")
(eval-prog '(let ((v (make-cv (fun () 1) 0)))
                  (let ((f (fun (y) (set! y 5))))
                    (f v)
                    v)))

(printf "----interaction with function application / call-by-value ----\n")
(eval-prog '(let ((ctx 1))
                (let ((printit (fun (arg)
                                    (set! ctx 1)
                                    (printf "arg is ~s\n" arg)
                                    (set! arg 6)
                                    (printf "arg is ~s\n" arg)
                                    (set! ctx 2)
                                    (printf "arg is ~s\n" arg)
                                    ))) 
                  (let ((x (make-cv (fun () ctx) 10)))
                    (set! ctx 2)
                    (set! x 5)
                    (printit x)
                    (printf "x is ~s\n" x)
                    ))))

(printf "----call-by-value semantics for compound contextual values----\n")
(eval-prog '(let ((v (make-cv (fun () 1) 0)))
                  (set! v 1)
                  (let ((w (make-cv (fun () 2) v)))
                    (set! w 2)
                    (let ((f (fun (y) 
                                  (set! y 5) 
                                  (cv-trace y))))
                      (f w)
                      (cv-trace w)))))

(printf "----let and call-by-value----\n")
(eval-prog '(let ((ctx 1))
                (let ((x (make-cv (fun () ctx) 10)))
                  (set! ctx 2)
                  (set! x 5)
                  (let ((y x))
                    (set! y 3)
                    (printf "x is ~s\n" x)
                    (cv-trace x)
                    (cv-trace y)))))