(define (parse sexp)
  (cond ((or (number? sexp)
             (string? sexp)
             (eqv? sexp #t)
             (eqv? sexp #f)) (make-lit-exp sexp))
  
	  ((and (list? sexp) (eqv? (car sexp) 'quote))
	   (make-lit-exp (cadr sexp)))	       
	       
	  ((symbol? sexp) (make-var-exp sexp))
          
          ((list? sexp)
           (let ((prim (assq (car sexp) *primitives*)))
	     (if prim
		 (make-prim-exp (cadr prim) (parse-exps (cdr sexp)))
                 
                 (case (car sexp)
                   ((if)
                    (make-if-exp (parse (cadr sexp))
                                 (parse (caddr sexp))
                                 (parse (cadddr sexp))))
                   
                 ;; (let ((x 4) (y 3)) ...)
                   ((let)
                    (make-let-exp (map car (cadr sexp))
                                  (parse-exps (map cadr (cadr sexp)))
                                  (parse-exps (cddr sexp))))
                   
                   ;; (fun (x y z) ...)
                   ((fun)
                    (make-fun-exp (cadr sexp)
                                  (parse-exps (cddr sexp))))
                   
                   ;; (set! x ...)
                   ((set!)
                    (make-set!-exp (cadr sexp)
                                   (parse (caddr sexp))))
                   
                   ;; (make-cv ctx init)
                   ((make-cv)
                    (make-make-cv-exp (parse (cadr sexp))
                                      (parse (caddr sexp))))
                   
                   ;; (cv-trace x)
                   ((cv-trace)
                    (make-cv-trace-exp (cadr sexp)))
                   
                   (else
                    ;; (f 1 2 3)
                    (make-app-exp (parse (car sexp))
                                  (parse-exps (cdr sexp))))
                   ))))))

(define parse-exps (lambda (exps) (map parse exps)))

;;; primitives
(define *primitives*
  `((+       ,(lambda args (apply + args)))
    (-       ,(lambda args (apply - args)))
    (*       ,(lambda args (apply * args)))
    (/       ,(lambda args (apply / args)))
    (=       ,(lambda args (apply = args)))
    (<       ,(lambda args (apply < args)))
    (>       ,(lambda args (apply > args)))
    (zero?   ,(lambda args (apply zero? args)))

    (not     ,(lambda args (apply not args)))

    (write   ,(lambda args (apply write args)))
    (printf  ,(lambda args (apply printf args)))
    (newline ,(lambda args (apply newline args)))

    (car     ,(lambda args (apply car  args)))
    (cdr     ,(lambda args (apply cdr  args)))
    (cons    ,(lambda args (apply cons args)))
    (list    ,(lambda args args))
    (length  ,(lambda args (apply length args)))
    (null?   ,(lambda args (apply null? args)))
    ))
