
;; AST FOR BASE

;;; programs 
(define-struct program (decls))

;;; decls
(define-struct declaration ())
(define-struct (class-decl     declaration) (cname sname decls))       
(define-struct (member-decl    declaration) (cname))                   
(define-struct (method-decl    member-decl) (rtype mname params body)) 
(define-struct (field-decl     member-decl) (type fname))              

;;; method/function bodies
(define-struct body (exps))

;;; params
(define-struct param (type name))
(define pnames (lambda (params) (map param-name params)))
(define ptypes (lambda (params) (map param-type params)))

;;; expressions
(define-struct expression ())

(define-struct (lit-exp         expression) (value)) ;; number/string/boolean/list/symbol
(define-struct (prim-app-exp    expression) (prim args))
(define-struct (if-exp          expression) (test then else))
(define-struct (and-exp         expression) (args))
(define-struct (or-exp          expression) (args))
(define-struct (let-exp      expression) (params args body))

;; functions (pointcut definitions)
; pointcuts are just first-class functions taking jp as parameter
; defined in the language but only evaluated by the interpreter (no app expression)
(define-struct (fun-exp   expression) (params body))

;; oo
(define-struct (vget     expression) (name))
(define-struct (vset     expression) (name val))
(define-struct (fget     expression) (name))
(define-struct (fset     expression) (name val))
(define-struct (call    expression) (target sig args))
(define-struct (scall    expression) (sig args))
(define-struct (new      expression) (class args))
(define-struct (instanceof  expression) (class target))

;; aspect deployment
(define-struct (depl-exp  expression) (ds asp body))
;; reflective access to current jp
(define-struct (this-jp-exp  expression) ())