
;;;;;;;;;;;;;;;; environments ;;;;;;;;;;;;;;;;

(define-struct environment ())
(define-struct (empty-env    environment) ())
(define-struct (extended-env environment) (ids vals env))

;; new environment with new mappings
(define new-env
  (lambda (ids vals)
    (extend-env ids vals (make-empty-env)))) 

;; extend environment with new mappings
(define extend-env
  (lambda (ids vals env)
    (make-extended-env ids (list->vector vals) env)))

;; lookup id in environment, apply action if found
(define env-lookup
  (lambda (action id env)
    (cond ((empty-env? env) (error 'env-lookup "No binding for ~s" id))
          ((extended-env? env)
           (let ((pos (find-position id (extended-env-ids env))))
             (if (number? pos)
                 (action pos env) ;; read or write
                 (env-lookup action id (extended-env-env env)))))
          (else (error 'env-lookup "not an environment -- ~s" env)))))

(define env-get
  (lambda (id env)
    (env-lookup (lambda (pos env) 
                  (vector-ref (extended-env-vals env) pos))
                id env)))

(define env-set!
  (lambda (id env nval)
    (env-lookup (lambda (pos env) 
                  (vector-set! (extended-env-vals env) pos nval))
                id env)))



;; HELPER FUNCTIONS

(define find-if
  (lambda (pred lst)
    (cond ((null? lst)      #f)
	  ((pred (car lst)) (car lst))
	  (else             (find-if pred (cdr lst))))))

(define collect-if
  (lambda (pred lst)
    (cond ((null? lst)      '())
	  ((pred (car lst)) (cons (car lst) (collect-if pred (cdr lst))))
	  (else             (collect-if pred (cdr lst))))))

(define find-position
  (lambda (sym lst)
    (let loop ((tail lst) (pos 0))
      (cond ((null? tail) #f)
	    ((eqv? sym (car tail)) pos)
	    (else (loop (cdr tail) (+ pos 1)))))))

(define find-last-position
  (lambda (sym lst)
    (let loop
	((tail lst) (curpos 0) (lastpos #f))
      (cond
       ((null? tail) lastpos)
       ((eqv? sym (car tail))
	(loop (cdr tail) (+ curpos 1) curpos))
       (else (loop (cdr tail) (+ curpos 1) lastpos))))))

(define union
  (lambda (l1 l2)
    (cond 
      ((null? l1) l2)
      ((null? l2) l1)
      ((member (car l1) l2) (union (cdr l1) l2))
      (else (union (cdr l1) (cons (car l1) l2))))))