(load "ds-oo.scm")   

(define test
  (lambda (case result)
    (begin
      (if (eq? case result)
          (write "passed")
          (write "failed"))
      (newline))))

(printf "****PLAIN OO TESTS***~n")

;; test cases
(test (run '((class Main Object
               (method void init ())
               (method void main () (+ 1 3 4 5))))) 13)

(test (run '((class Main Object
               (method void init ())
               (method void main () (and #t #f))))) #f)

(test (run '((class Main Object
	      (method void init ())
	      (method void main () 
                      (send this init '())
                      (+ 1 (car (cdr '(1 3 4)))))))) 4)

(test (run `((class Main Object
	(method void init () (super init))
	(method int main ()
	  (let (((Employee john) (new Employee "john"))
		((Employee bob)  (new Employee "bob")))
	    (send john pay)
	    (send bob pay))))

      (class Employee Object
	(field string name)
	(method void init ((string name))
	  (super init)
	  (fset! name name))

	(method void print () (write (fget name)))

	(field int salary)
	(method int pay ()
	  (write 'paying:) (send this print) (newline)
	  (fget salary))))) 0)

(test (run `((class Main Object
	(method void init () (super init))
	(method int main () (send this fact 6))
	(method int fact ((int n))
	  (if (< n 1) 1
	      (* n (send this fact (- n 1)))))))) 720)


(test (run `((class Main Object
               (method void main ()
                       (let (((Figure fig)  (new Figure)))
                         (let (
                               ((Point  p1)  (send fig make-point   0  0))
                               ((Point  p2)  (send fig make-point  50 50))
                               ((Line   l1)  (send fig make-line   100 50 150 100))
                               ((Line   l2)  (send fig make-line   150 50 100 100)))
                           
                           (send fig dump)
                           (write "moving elements")(newline)
                           (send p2 set-x 30)
                           (send l2 set-p2 p2)
                           (send fig dump)))))
             
      (class Figure Object
	     (field LinkedList element-list)
	     (method void init () (super init)
		     (fset! element-list '()))

	     (method void dump ()
		     (write "figure:") (newline)
		     (send this dump-elements (fget element-list)))
        
	     (method void dump-elements ((LinkedList elements))
		     (if (null? elements)
			 'done
			 (let ()
			   (send (send elements first)
				 print)
			   (newline)
			   (send this dump-elements
				 (send elements next)))))

	     (method Point make-point ((int x) (int y))
		     (let (((Point p) (new Point x y)))
		       (fset! element-list
			    (new LinkedList p (fget element-list))
			    )		       
		       p))

	     (method Line make-line ((int x1) (int y1) (int x2) (int y2))
		     (let (((Point p1) (new Point x1 y1))
			   ((Point p2) (new Point x2 y2)))
		       (let (((Line l) (new Line p1 p2)))
			 (fset! element-list
				(new LinkedList l (fget element-list)))		       
			 l))))

      (class LinkedList Object
	     (field FigureElement el)
	     (field LinkedList next)
	     (method void init ((FigureElement el) (LinkedList next))
		     (super init)
		     (fset! el el)
		     (fset! next next))
	     (method FigureElement first () (fget el))
	     (method LinkedList next () (fget next)))

      (class FigureElement Object
	     (method void init () 
	       (super init))
	     (method void move-by ((int x) (int y)) 'done))
      
      (class Point FigureElement
	     (method void init ((int x) (int y)) 
		     (super init)
		     (fset! x x)
		     (fset! y y))
	     (field int x)
	     (field int y)
	     (method int get-x () (fget x))
	     (method int get-y () (fget y))
	     (method void set-x ((int x)) (fset! x x))
	     (method void set-y ((int y)) (fset! y y))
	     (method void move-by ((int x) (int y))
	       (send this set-x (+ x (send this get-x)))
	       (send this set-y (+ y (send this get-y))))

	     (method void print ()
		     (write 'Point<)
		     (write (send this get-x))
		     (write ':)
		     (write (send this get-y))
		     (write '>)
		     ))

      (class Line FigureElement
	     (method void init ((Point p1) (Point p2))
		     (fset! p1 p1)
		     (fset! p2 p2))
	     (field Point p1)
	     (field Point p2)
	     (method int get-p1 () (fget p1))
	     (method int get-p2 () (fget p2))
	     (method void set-p1 ((Point p1)) (fset! p1 p1))
	     (method void set-p2 ((Point p2)) (fset! p2 p2))
	     (method void move-by ((int x) (int y))
	       (send p1 move-by x y)
	       (send p2 move-by x y))

	     (method void print ()
		     (write 'line<)
		     (send (send this get-p1) print)
		     (write '-)
		     (send (send this get-p2) print)
		     (write '>))))) 'done)

(test (run `((class Point Object
               (field int x)
               (field int y)
               (method void init ()
                       (fset! x 0)
                       (fset! y 0))
               (method void movex ((int dx))
                       (fset! x (+ dx (fget x)))))
       
       (class XorO Point
         (field boolean x)
         (method void init ()
                 (super init)
                 (fset! x #f)))
       
       (class ColoredXorO XorO
         (field int c)
         (method void init ()
                 (super init)
                 (fset! c 1)))
       
       (class Main Object
         (method void main ()
                 (let (((Point o) (new ColoredXorO)))
                   (send o movex 1)
                   'done)))))
         
                  'done)

;; Testing aspects
(printf "~n~n~n****AO TESTS***~n")

(printf "~n---basic test call (match)~n")
(test (run '((class Main Object
               (method void init () 2)
               (method void foo() 2)
               (method void main ()
                       (let (((Fun tpc) (fun (jp) #t))
                             ((Fun fpc) (fun (jp) #f)))
                         
                         (deploy (list tpc fpc tpc)
                                 (list (fun (jp) (and
                                                  (eq? (kind jp) 'call)
                                                  (eq? (name jp) 'foo)))
                                       (fun (jp) (printf "trace~n")))
                                  (+ 1 (send this foo) 4 5))))))) 12)

(printf "~n---basic test exec (match)~n")
(test (run '((class Main Object
               (method void init () 2)
               (method void foo() 2)
               (method void main ()
                       (let (((Fun tpc) (fun (jp) #t))
                             ((Fun fpc) (fun (jp) #f)))
                         
                         (deploy (list tpc fpc tpc)
                                 (list (fun (jp) (and
                                                  (eq? (kind jp) 'exec)
                                                  (eq? (name jp) 'foo)))
                                       (fun (jp) (printf "trace~n")))
                                  (+ 1 (send this foo) 4 5))))))) 12)

(printf "~n---basic test new (match)~n")
(test (run '((class Main Object
               (method void init () 2)
               (method void foo() 2)
               (method void main ()
                       (let (((Fun tpc) (fun (jp) #t))
                             ((Fun fpc) (fun (jp) #f)))
                         
                         (deploy (list tpc fpc tpc)
                                 (list (fun (jp) (and
                                                  (eq? (kind jp) 'new)
                                                  (eq? (target-type jp) 'Main))) 
                                       (fun (jp) (printf "trace~n")))
                                 (+ 1 (send (new Main) foo))
                                 )))))) 3)


(printf "~n---deploy-d test (match once)~n")

(test (run '(
 (class Main Object
   (method void main ()
           (let (((CarFactory fact) (new CarFactory))
                 ((Aspect speedLimit) 
                  (list (fun (jp) (and (eq? (kind jp) 'exec) (eq? (name jp) 'setSpeed)))
                        (fun (jp) (if (> (car (args jp)) 120) 
                                      (printf "!!Too Fast!!~n") 
                                      #t))))) 
             (let (((Fun tpc) (fun (jp) #t))
                   ((Fun fpc) (fun (jp) #f)))
               (deploy (list tpc fpc tpc) ;; deploy-d
                       speedLimit
                       (send (send fact get 500) drive))  ;; match
               (send (send fact get 200) drive)))         ;; no match
           'done))
                 
 (class CarFactory Object
   (method Car get ((int val))
           (if (< val 500)
               (new Lotus)
               (new Jaguar))))

 (class Car Object
   (field int currentSpeed)
   (method void init () 
           (send this setSpeed 150))
   (method void drive () 
           (printf "driving at ~a~n" (fget currentSpeed)))
   (method void setSpeed ((int s))
           (fset! currentSpeed s)))
 
 (class Lotus Car
   (method void init () (super init))
   (method void drive ()
           (printf "Lotus ")
           (super drive)))
 
 (class Jaguar Car
   (method void init () (super init))
   (method void drive ()
           (printf "Jaguar ")
           (super drive))))) 'done)
 
 
(printf "~n---deploy-s test (match twice)~n")
(test (run '(
 (class Main Object
   (method void main ()
           (let (((CarFactory fact) (new CarFactory)))
             (let (((Car c) (send fact get 400))) ;; once
               (send c drive)
               (send c setSpeed 100)
               (send c drive)
               (send c setSpeed 150)  ;; twice
               (send c drive)))  
             'done))
                 
 (class CarFactory Object
   (method Car get ((int val))
           (let (((Aspect speedLimit) 
                  (list (fun (jp) (and (eq? (kind jp) 'exec) (eq? (name jp) 'setSpeed)))
                        (fun (jp) (if (> (car (args jp)) 120) 
                                      (printf "!!Too Fast!!~n") 
                                      #t))))) 
             (let (((Fun tpc) (fun (jp) #t))
                   ((Fun fpc) (fun (jp) #f)))
               (deploy (list fpc tpc tpc) ;; deploy-s
                       speedLimit
                       (if (< val 500)
                           (new Lotus)
                           (new Jaguar)))))))

 (class Car Object
   (field int currentSpeed)
   (method void init ()
           (send this setSpeed 150))
   (method void drive () 
           (printf "driving at ~a~n" (fget currentSpeed)))
   (method void setSpeed ((int s))
           (fset! currentSpeed s)))
 
 (class Lotus Car
   (method void init () (super init))
   (method void drive ()
           (printf "Lotus ")
           (super drive)))
 
 (class Jaguar Car
   (method void init () (super init))
   (method void drive ()
           (printf "Jaguar ")
           (super drive))))) 'done)
 
 
(printf "~n---Case 1: refactoring with deploy-s (no match)~n")
(test (run '(
 (class Main Object
   (method void main ()
           (let (((CarFactory fact) (new CarFactory)))
             (let (((Car c) (send fact get 400))) ;; once
               (send c drive)
               (send c setSpeed 100)
               (send c drive)
               (send c setSpeed 150)  ;; twice
               (send c drive)))  
             'done))
                 
 (class CarFactory Object
   (method Car get ((int val))
           (let (((Aspect speedLimit) 
                  (list (fun (jp) (and (eq? (kind jp) 'exec) (eq? (name jp) 'setSpeed)))
                        (fun (jp) (if (> (car (args jp)) 120) 
                                      (printf "!!Too Fast!!~n") 
                                      #t))))) 
             (let (((Fun tpc) (fun (jp) #t))
                   ((Fun fpc) (fun (jp) #f))
                   ((LotusFactory lotusFact) (new LotusFactory))
                   ((JaguarFactory jaguarFact) (new JaguarFactory)))
               (deploy (list fpc tpc tpc) ;; deploy-s
                       speedLimit
                       (if (< val 500)
                           (send lotusFact get)
                           (send jaguarFact get)
                           ))))))
 
 (class JaguarFactory Object
   (method Car get () (new Jaguar)))

 (class LotusFactory Object
   (method Car get () (new Lotus)))
 
 (class Car Object
   (field int currentSpeed)
   (method void init ()
           (send this setSpeed 150))
   (method void drive () 
           (printf "driving at ~a~n" (fget currentSpeed)))
   (method void setSpeed ((int s))
           (fset! currentSpeed s)))
 
 (class Lotus Car
   (method void init () (super init))
   (method void drive ()
           (printf "Lotus ")
           (super drive)))
 
 (class Jaguar Car
   (method void init () (super init))
   (method void drive ()
           (printf "Jaguar ")
           (super drive))))) 'done)
   
   
   
               
(printf "~n---Case 1: refactoring with deploy(true,true,_) (match twice)~n")
(test (run '(
 (class Main Object
   (method void main ()
           (let (((CarFactory fact) (new CarFactory)))
             (let (((Car c) (send fact get 400))) ;; once
               (send c drive)
               (send c setSpeed 100)
               (send c drive)
               (send c setSpeed 150)  ;; twice
               (send c drive)))  
             'done))
                 
 (class CarFactory Object
   (method Car get ((int val))
           (let (((Aspect speedLimit) 
                  (list (fun (jp) (and (eq? (kind jp) 'exec) (eq? (name jp) 'setSpeed)))
                        (fun (jp) (if (> (car (args jp)) 120) 
                                      (printf "!!Too Fast!!~n") 
                                      #t))))) 
             (let (((Fun tpc) (fun (jp) #t))
                   ((Fun fpc) (fun (jp) #f))
                   ((LotusFactory lotusFact) (new LotusFactory))
                   ((JaguarFactory jaguarFact) (new JaguarFactory)))
               (deploy (list tpc tpc tpc) ;; deploy(true,true,_)
                       speedLimit
                       (if (< val 500)
                           (send lotusFact get)
                           (send jaguarFact get)
                           ))))))
 
 (class JaguarFactory Object
   (method Car get () (new Jaguar)))

 (class LotusFactory Object
   (method Car get () (new Lotus)))
 
 (class Car Object
   (field int currentSpeed)
   (method void init ()
           (send this setSpeed 150))
   (method void drive () 
           (printf "driving at ~a~n" (fget currentSpeed)))
   (method void setSpeed ((int s))
           (fset! currentSpeed s)))
 
 (class Lotus Car
   (method void init () (super init))
   (method void drive ()
           (printf "Lotus ")
           (super drive)))
 
 (class Jaguar Car
   (method void init () (super init))
   (method void drive ()
           (printf "Jaguar ")
           (super drive))))) 'done)



   
(printf "~n---Case 2: pervasive propagation with deploy(true,true,_) (match all execs)~n")
(test (run '(
 (class Main Object
   (method void main ()  
           (let (((CarFactory fact) (new CarFactory))
                 ((Client cl) (new Client)))
             (send fact order 500 cl)
             (send cl play)
             'done)))
 
 (class CarFactory Object
   (field ProdLine prodLine)
   (method void init ()
           (fset! prodLine (new ProdLine)))
   (method int order ((int val) (Client c))
           (let (((Aspect qa) (list (fun (jp) (eq? (kind jp) 'exec))
                                    (fun (jp) (printf ">> QA seeing ~a~n" (name jp))))))
             (let (((Fun tpc) (fun (jp) #t))
                   ((Fun fpc) (fun (jp) #f)))
               (deploy (list tpc tpc tpc) ;; deploy(true,true,_)
                       qa
                       (send (fget prodLine) createAndDispatch val c))))))
 
 (class ProdLine Object
   (method void createAndDispatch ((int val) (Client c))
           (let (((DBAccess dba) (new DBAccess)))
             (send dba queries)
             (let (((Car car) (new Jaguar)))
               (send c receive car)))))
           
 (class Client Object
   (field Car mycar)
   (method void receive ((Car c))
           (printf "I received my car~n")
           (fset! mycar c))
   (method void play ()
           (send (fget mycar) setSpeed 150)
           (send (fget mycar) drive)))
           
 
 (class DBAccess Object
   (method void query1 ()
           (printf "doing DB queries 1~n"))
   (method void query2 ()
           (printf "doing DB queries 2~n"))
   (method void query3 ()
           (printf "doing DB queries 3~n"))
   (method void queries ()
           (send this query1)
           (send this query2)
           (send this query3)))
 
 (class Car Object
   (field int currentSpeed)
   (method void init ()
           (send this setSpeed 150))
   (method void drive () 
           (printf "driving at ~a~n" (fget currentSpeed)))
   (method void setSpeed ((int s))
           (fset! currentSpeed s)))
 
 (class Lotus Car
   (method void init () (super init))
   (method void drive ()
           (printf "Lotus ")
           (super drive)))
 
 (class Jaguar Car
   (method void init () (super init))
   (method void drive ()
           (printf "Jaguar ")
           (super drive)))
 )) 'done)

 




(printf "~n---Case 3: control on propagation with deploy(!DBAccess,Car,_)~n")
(printf "does not see activity below DBAccess, sees activity of car before AND after dispatch~n")
(test (run '(
 (class Main Object
   (method void main ()  
           (let (((CarFactory fact) (new CarFactory))
                 ((Client cl) (new Client)))
             (send fact order 500 cl)
             (send cl play)
             'done)))
 
 (class CarFactory Object
   (field ProdLine prodLine)
   (method void init ()
           (fset! prodLine (new ProdLine)))
   (method int order ((int val) (Client c))
           (let (((Aspect qa) (list (fun (jp) (eq? (kind jp) 'exec))
                                    (fun (jp) (printf ">> QA seeing ~a~n" (name jp))))))
             (let (((Fun tpc) (fun (jp) #t))
                   ((Fun fpc) (fun (jp) #f)))
               (deploy (list (fun (jp) (not (eqt? (target-type jp) 'DBAccess)))
                             (fun (jp) (eqt? (target-type jp) 'Car))
                             tpc)
                       qa
                       (send (fget prodLine) createAndDispatch val c))))))
 
 (class ProdLine Object
   (method void createAndDispatch ((int val) (Client c))
           (let (((DBAccess dba) (new DBAccess)))
             (send dba queries)
             (let (((Car car) (new Jaguar)))
               (send c receive car)))))
           
 (class Client Object
   (field Car mycar)
   (method void receive ((Car c))
           (printf "I received my car~n")
           (fset! mycar c))
   (method void play ()
           (send (fget mycar) setSpeed 150)
           (send (fget mycar) drive)))
           
 (class DBAccess Object
   (method void query1 ()
           (printf "doing DB queries 1~n"))
   (method void query2 ()
           (printf "doing DB queries 2~n"))
   (method void query3 ()
           (printf "doing DB queries 3~n"))
   (method void queries ()
           (send this query1)
           (send this query2)
           (send this query3)))
   
 (class Car Object
   (field int currentSpeed)
   (method void init ()
           (send this setSpeed 150))
   (method void drive () 
           (printf "driving at ~a~n" (fget currentSpeed)))
   (method void setSpeed ((int s))
           (fset! currentSpeed s)))
 
 (class Lotus Car
   (method void init () (super init))
   (method void drive ()
           (printf "Lotus ")
           (super drive)))
 
 (class Jaguar Car
   (method void init () (super init))
   (method void drive ()
           (printf "Jaguar ")
           (super drive)))
 )) 'done)


(printf "~n---Case 4: deployment specific filtering d(true,_,target==c) : match only once~n")
(test (run '(
 (class Main Object
   (method void main ()
           (let (((CarFactory fact) (new CarFactory))
                 ((Aspect speedLimit) 
                  (list (fun (jp) (and (eq? (kind jp) 'exec) (eq? (name jp) 'setSpeed)))
                        (fun (jp) (if (> (car (args jp)) 120) 
                                      (printf "!!Too Fast!!~n") 
                                      #t))))) 
                 (let (((Fun tpc) (fun (jp) #t))
                       ((Fun fpc) (fun (jp) #f)))
                   (let (((Car c1) (send fact get 500))
                         ((Car c2) (send fact get 400))
                         ((Car c3) (send fact get 700))
                         ((Car c4) (send fact get 300)))
                         
                     (deploy (list tpc fpc 
                                   (fun (jp) (eq? (target jp) c3))) ;; only for c3
                             speedLimit
                             (send (new TestDrive) driveCars (list c1 c2 c3 c4))))))
             'done))
                 
 (class TestDrive Object
   (method void driveCars ((List cars)) 
           (if (null? cars) 
               #t
               (let (((Dum dum) (send this driveCar (car cars)))) ;; emulate seq
                 (send this driveCars (cdr cars)))))
   
   (method void driveCar ((Car c))
           (send c setSpeed 150)
           (send c drive)))
 
 (class CarFactory Object
   (method Car get ((int val))
           (if (< val 500)
               (new Lotus)
               (new Jaguar))))

 (class Car Object
   (field int currentSpeed)
   (method void init () 
           (send this setSpeed 0))
   (method void drive () 
           (printf "driving at ~a~n" (fget currentSpeed)))
   (method void setSpeed ((int s))
           (fset! currentSpeed s)))
 
 (class Lotus Car
   (method void init () (super init))
   (method void drive ()
           (printf "Lotus ")
           (super drive)))
 
 (class Jaguar Car
   (method void init () (super init))
   (method void drive ()
           (printf "Jaguar ")
           (super drive))))) 'done)
 